/*
 * Decompiled with CFR 0.152.
 */
package com.tp_link.eap.monitor.mesh.service.impl;

import com.tp_link.eap.domain.eap.Ap;
import com.tp_link.eap.domain.eap.StatCurrentAp;
import com.tp_link.eap.domain.eapstats.DevCap;
import com.tp_link.eap.domain.eapstats.DeviceMisc;
import com.tp_link.eap.domain.global.OperationResult;
import com.tp_link.eap.domain.mesh.bean.CandidateParentApInfo;
import com.tp_link.eap.domain.mesh.bean.FirstInfomRecord;
import com.tp_link.eap.domain.mesh.bean.MeshConf;
import com.tp_link.eap.domain.mesh.document.MeshSetting;
import com.tp_link.eap.domain.mesh.document.StatMeshInfo;
import com.tp_link.eap.domain.mesh.pojo.ConfigChildAP;
import com.tp_link.eap.domain.mesh.pojo.ConfigMesh;
import com.tp_link.eap.domain.mesh.pojo.ConfigTargetIP;
import com.tp_link.eap.domain.mesh.pojo.Mesh;
import com.tp_link.eap.monitor.globalsetting.service.g;
import com.tp_link.eap.monitor.mesh.repo.MeshSettingRepository;
import com.tp_link.eap.monitor.mesh.repo.StatMeshInfoRepository;
import com.tp_link.eap.monitor.mesh.service.a;
import com.tp_link.eap.monitor.mesh.service.c;
import com.tp_link.eap.monitor.monitor.cache.CacheTask;
import com.tp_link.eap.monitor.monitor.realtime.RealtimeStatus;
import com.tp_link.eap.monitor.monitor.repo.ApRepository;
import com.tp_link.eap.monitor.monitor.repo.StatCurApRepository;
import com.tp_link.eap.monitor.record.service.b;
import com.tp_link.eap.util.e;
import com.tp_link.eap.util.l;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component(value="meshService")
public class MeshServiceImpl
implements a {
    @Autowired
    private StatMeshInfoRepository b;
    @Autowired
    private ApRepository c;
    @Autowired
    private StatCurApRepository d;
    @Autowired
    private MeshSettingRepository e;
    @Autowired
    private b f;
    @Autowired
    private g g;
    @Autowired
    private com.tp_link.eap.monitor.record.service.a h;
    @Autowired
    private com.tp_link.eap.monitor.monitor.service.b i;
    @Autowired
    private c j;
    private static final Logger k = LoggerFactory.getLogger(MeshServiceImpl.class);
    public static final double a = 0.7;
    private static final double[][] l = new double[][]{{5.0, 29.0}, {9.0, 58.0}, {12.0, 87.0}, {16.0, 117.0}, {20.0, 175.0}, {24.0, 234.0}, {26.0, 263.0}, {29.0, 292.0}, {33.0, 351.0}, {35.0, 390.0}};

    @Override
    public String autoElectParentAp(Ap childAp, String site) {
        if (childAp == null) {
            k.error("Invalid input");
            return null;
        }
        k.debug("start to autoElectParentAp for {}", (Object)childAp.getMac());
        StatMeshInfo statMeshInfo = this.b.findByMac(childAp.getMac());
        if (statMeshInfo == null) {
            k.warn("Failed to autoElectParentAp for {}, as statMeshInfo is null", (Object)childAp.getMac());
            return null;
        }
        return this.autoElectParentAp(statMeshInfo, childAp, site);
    }

    public String autoElectParentAp(StatMeshInfo statMeshInfo, Ap apInfo, String site) {
        k.debug(site);
        if (statMeshInfo == null || apInfo == null) {
            k.error("Invalid input");
            return null;
        }
        List list = statMeshInfo.getCandidateParentAps();
        if (CollectionUtils.isEmpty((Collection)list)) {
            k.warn("Failed to find any candidateParentAps for {}", (Object)statMeshInfo.getMac());
            return null;
        }
        double d2 = 0.0;
        double d3 = 0.0;
        int n2 = 0;
        int n3 = 0;
        int n4 = -1000;
        Ap ap = null;
        for (CandidateParentApInfo candidateParentApInfo : list) {
            Ap ap2 = this.c.findByMac(candidateParentApInfo.getMac());
            if (ap2 == null || !ap2.getSite().equals(site)) {
                k.debug("candidateParentAp {} of {} not exist", (Object)candidateParentApInfo.getMac(), (Object)statMeshInfo.getMac());
                continue;
            }
            d2 = this.a(candidateParentApInfo, ap2, statMeshInfo.getMac());
            k.debug("rate uplink by {} is {}", (Object)ap2.getMac(), (Object)d2);
            if (!(d2 > 0.0)) continue;
            k.debug("candiParentAp: {}  snr: {}  rssi: {}  rate: {}  childNum: {}  hop: {}", new Object[]{ap2.getMac(), candidateParentApInfo.getSnr(), candidateParentApInfo.getRssi(), d2, candidateParentApInfo.getChildsNum() - 1, candidateParentApInfo.getHop()});
            k.debug("hops: {}, brothersNum: {}", (Object)candidateParentApInfo.getHop(), (Object)candidateParentApInfo.getChildsNum());
            if (!(d2 > d3 || d2 == d3 && n2 > candidateParentApInfo.getHop() || d2 == d3 && n2 == candidateParentApInfo.getHop() && n3 > candidateParentApInfo.getChildsNum()) && (d2 != d3 || n2 != candidateParentApInfo.getHop() || n3 != candidateParentApInfo.getChildsNum() || candidateParentApInfo.getRssi() <= n4)) continue;
            d3 = d2;
            ap = ap2;
            n2 = candidateParentApInfo.getHop();
            n3 = candidateParentApInfo.getChildsNum();
            n4 = candidateParentApInfo.getRssi();
        }
        k.debug("parent is {}, rate is {}", (Object)(ap != null ? ap.getMac() : null), (Object)d3);
        return ap != null ? ap.getMac() : null;
    }

    private double a(CandidateParentApInfo candidateParentApInfo, Ap ap, String string) {
        if (candidateParentApInfo == null || ap == null || string == null) {
            k.error("Invalid input");
            return -1.0;
        }
        Ap ap2 = this.i.getApByMac(string);
        if (!(ap2 == null || ap2.getStatus() != 2 && ap2.getStatus() != 4 || candidateParentApInfo.getUptime() != null && !com.tp_link.eap.util.l.a((long)candidateParentApInfo.getUptime().getTime(), (long)30000L))) {
            k.debug("{} is not suitable now", (Object)ap.getMac());
            return -1.0;
        }
        try {
            if (string.equals(ap.getMac())) {
                k.debug("loop detected for {}, ignore this link", (Object)string);
                return -1.0;
            }
            if (ap.getStatus() != 1) {
                k.debug("{} is disconnected", (Object)ap.getMac());
                return -1.0;
            }
            if (ap.getRealtimeStatus() != RealtimeStatus.a.ordinal() && ap.getRealtimeStatus() != RealtimeStatus.d.ordinal()) {
                k.debug("{} is not suitable now", (Object)ap.getMac());
                return -1.0;
            }
            if (FirstInfomRecord.isExit((String)ap.getMac())) {
                k.debug("{} is not suitable now", (Object)ap.getMac());
                return -1.0;
            }
            int n2 = this.a(ap);
            if (n2 >= 4 && this.j.getDisChildNum(ap) == 0) {
                k.debug("{} has too many({}) childs, ignore", (Object)ap.getMac(), (Object)n2);
                return -1.0;
            }
            int n3 = n2 + 1 > 4 ? n2 + 1 : 4;
            candidateParentApInfo.setChildsNum(Integer.valueOf(n3));
            StatCurrentAp statCurrentAp = this.d.findByApMac(ap.getMac());
            if (statCurrentAp == null) {
                k.debug("Failed to find StatCurrentAp for {}", (Object)ap.getMac());
                return -1.0;
            }
            double d2 = this.a(candidateParentApInfo.getSnr(), n2 + 1, com.tp_link.eap.util.l.a((DevCap)ap2.getDevCap()), com.tp_link.eap.util.l.a((DevCap)ap.getDevCap()));
            k.debug("wifiRate is {}, brothersNum is {}", (Object)d2, (Object)candidateParentApInfo.getChildsNum());
            if (!ap.getWirelessLinked().booleanValue()) {
                candidateParentApInfo.setHop(Integer.valueOf(0));
                return d2 > statCurrentAp.getLanRate() ? statCurrentAp.getLanRate() : d2;
            }
            StatMeshInfo statMeshInfo = this.b.findByMac(ap.getMac());
            if (statMeshInfo == null) {
                k.warn("Failed to find StatMeshInfo for {}", (Object)ap.getMac());
                return -1.0;
            }
            if (statMeshInfo.getUplinkInfo() == null || statMeshInfo.getUplinkInfo().getUptime() == null || com.tp_link.eap.util.l.a((long)statMeshInfo.getUplinkInfo().getUptime().getTime(), (long)60000L)) {
                k.debug("{} is not suitable now", (Object)ap.getMac());
                return -1.0;
            }
            int n4 = this.j.getHop(ap.getMac());
            if (n4 < 0 || n4 >= 3) {
                k.debug("to many hops({})", (Object)n4);
                return -1.0;
            }
            boolean bl = this.a(ap, statMeshInfo, string);
            if (!bl) {
                k.debug("{} is not suit for {}", (Object)ap.getMac(), (Object)string);
                return -1.0;
            }
            candidateParentApInfo.setHop(Integer.valueOf(n4));
            k.debug("candiParentMeshInfo.getApRate() is {}", (Object)statMeshInfo.getApRate());
            double d3 = this.a(d2, statMeshInfo.getApRate());
            k.debug("apRate is {}, hop is {}", (Object)d3, (Object)candidateParentApInfo.getHop());
            return d3 > statMeshInfo.getLanRate() ? statMeshInfo.getLanRate() : d3;
        }
        catch (Exception exception) {
            k.warn(exception.toString(), (Throwable)exception);
            return -1.0;
        }
    }

    private boolean a(Ap ap, StatMeshInfo statMeshInfo, String string) {
        if (ap == null || statMeshInfo == null || string == null) {
            k.error("Invaid input");
            return false;
        }
        if (ap.getStatus() != 1) {
            statMeshInfo.setApRate(0.0);
            return false;
        }
        MeshConf meshConf = ap.getMeshConf();
        if (meshConf == null || meshConf.getParentApMac() == null) {
            k.error("{} missing parentAp configure", (Object)ap.getMac());
            statMeshInfo.setApRate(0.0);
            return false;
        }
        Ap ap2 = this.c.findByMac(meshConf.getParentApMac());
        if (ap2 == null) {
            k.error("parentAp {} of {} not exist", (Object)meshConf.getParentApMac(), (Object)ap.getMac());
            statMeshInfo.setApRate(0.0);
            return false;
        }
        if (string.equals(ap2.getMac())) {
            k.debug("loop detected for {}, ignore this link", (Object)string);
            return false;
        }
        k.debug("parent of {} is {}", (Object)ap.getMac(), (Object)ap2.getMac());
        if (ap2.getStatus() != 1) {
            statMeshInfo.setApRate(0.0);
            return false;
        }
        StatCurrentAp statCurrentAp = this.d.findByApMac(ap2.getMac());
        if (statCurrentAp == null) {
            k.debug("Failed to find statCurrentAp for {}", (Object)ap2.getMac());
            return false;
        }
        double d2 = this.a(statMeshInfo.getUplinkInfo().getSnr(), this.a(ap2), com.tp_link.eap.util.l.a((DevCap)ap.getDevCap()), com.tp_link.eap.util.l.a((DevCap)ap2.getDevCap()));
        k.debug("wifiRate is {}", (Object)d2);
        k.debug("" + ap2.getWirelessLinked());
        if (!ap2.getWirelessLinked().booleanValue()) {
            statMeshInfo.setLanRate(statCurrentAp.getLanRate());
            statMeshInfo.setApRate(d2);
            k.debug("" + statMeshInfo.getMac() + " " + statMeshInfo.getLanRate() + " " + statMeshInfo.getApRate());
        } else {
            StatMeshInfo statMeshInfo2 = this.b.findByMac(meshConf.getParentApMac());
            if (statMeshInfo2 == null) {
                statMeshInfo.setApRate(0.0);
                return false;
            }
            boolean bl = this.a(ap2, statMeshInfo2, string);
            if (!bl) {
                return false;
            }
            statMeshInfo.setLanRate(statMeshInfo2.getLanRate());
            statMeshInfo.setApRate(this.a(d2, statMeshInfo2.getApRate()));
        }
        return true;
    }

    private double a(double d2, double d3) {
        double d4 = 0.7;
        return d2 * d3 / (d2 + d3) * d4;
    }

    private double a(int n2, int n3, int n4, int n5) {
        double d2 = 0.0;
        if (n3 <= 0) {
            k.warn("Invalid brothersNum {}", (Object)n3);
            return 0.0;
        }
        int n6 = Math.min(n4, n5);
        for (int i2 = 0; i2 < l.length && (double)n2 >= l[i2][0]; ++i2) {
            d2 = (double)n6 * l[i2][1];
        }
        return d2 /= (double)n3;
    }

    private int a(Ap ap) {
        MeshConf meshConf = ap.getMeshConf();
        if (meshConf == null || meshConf.getChildApMacs() == null) {
            return 0;
        }
        return meshConf.getChildApMacs().size();
    }

    @Override
    public OperationResult sendMeshSetting(MeshSetting meshSetting, String site, int operation) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        List<Ap> list = this.c.findBySiteAndAdopted(site, true);
        if (!CollectionUtils.isEmpty(list)) {
            for (Ap ap : list) {
                hashMap.put(ap.getMac(), ap.getMac());
                Mesh mesh = new Mesh();
                mesh.setIsNewConfig(0);
                ConfigMesh configMesh = new ConfigMesh();
                if (ap.getWirelessLinked().booleanValue()) {
                    configMesh.setEnable(1);
                } else {
                    configMesh.setEnable(meshSetting.isMeshEnable() ? 1 : 0);
                }
                mesh.setConfigMesh(configMesh);
                ConfigTargetIP configTargetIP = new ConfigTargetIP();
                configTargetIP.setEnable(meshSetting.getDefGatewayEnable());
                configTargetIP.setTargetIP(meshSetting.getGateway());
                mesh.setConfigTargetIP(configTargetIP);
                if (operation == 1) {
                    mesh.setIsNewConfig(1);
                    List<ConfigChildAP> list2 = this.g.a(ap.getMeshConf(), site);
                    mesh.setConfigChildAPList(list2);
                }
                this.a(ap, mesh, operation);
            }
        }
        return com.tp_link.eap.util.e.bc;
    }

    @Override
    public OperationResult mesh2WiredHandler(Ap ap, String site) {
        MeshSetting meshSetting = this.e.findByKeyAndSite("mesh", site);
        if (meshSetting == null) {
            k.error("Failed to get meshSetting for site {}", (Object)site);
            return com.tp_link.eap.util.e.bf;
        }
        if (meshSetting.isMeshEnable()) {
            k.debug("Now mesh is on");
            return com.tp_link.eap.util.e.bc;
        }
        Mesh mesh = new Mesh();
        ConfigMesh configMesh = new ConfigMesh();
        configMesh.setEnable(0);
        mesh.setConfigMesh(configMesh);
        return this.a(ap, mesh, 0);
    }

    private OperationResult a(Ap ap, Mesh mesh, int n2) {
        if (ap == null || mesh == null) {
            k.warn("Invalid input");
            return com.tp_link.eap.util.e.be;
        }
        if (!com.tp_link.eap.util.l.c((DeviceMisc)ap.getDeviceMisc())) {
            k.debug("No need to send mesh global setting msg to those unsupport mesh aps");
            return com.tp_link.eap.util.e.bc;
        }
        if (ap.getStatus() != 1) {
            k.debug("No need to send mesh global setting msg to those disconnected aps");
            return com.tp_link.eap.util.e.bc;
        }
        String string = ap.getMac();
        if (n2 == 0 && ap.getWirelessLinked().booleanValue()) {
            k.debug("ignore wireless connected aps for send mesh off msg");
            this.i.handleDisconnectedAp(string, true);
            CacheTask.a.a(string);
            return com.tp_link.eap.util.e.bc;
        }
        this.h.refreshRecord(string, "mesh", mesh);
        return com.tp_link.eap.util.e.bc;
    }
}

